---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：278-OAuth リダイレクト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **C-14**: WebIde::DefaultOauthApplicationの詳細未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/ide/oauth_redirect.html.haml`（4行）
- E-02: `app/controllers/ide_controller.rb`（30-37行目）
- E-03: `app/helpers/ide_helper.rb`（61-71行目）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（279行目）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（337行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「OAuth リダイレクト」である | E-04 | ○ |
| C-02 | テンプレートファイルはoauth_redirect.html.hamlである | E-01 | ○ |
| C-03 | 機能No.88「OAuth2プロバイダ」に関連 | E-05 | ○ |
| C-04 | URLは/-/ide/oauth_redirect | E-02（30行目：アクション名から推測） | ○ |
| C-05 | OAuthアプリケーション未設定時は404 | E-02（34行目） | ○ |
| C-06 | fullscreenレイアウトを使用 | E-02（36行目） | ○ |
| C-07 | minimal: trueオプションを使用 | E-02（36行目） | ○ |
| C-08 | ページタイトルはIDE | E-01（1行目） | ○ |
| C-09 | ローディングメッセージはAuthenticating... | E-01（3行目） | ○ |
| C-10 | ide_oauth_dataヘルパーを使用 | E-01（3行目）, E-03（61-71行目） | ○ |
| C-11 | client-idデータ属性を渡す | E-03（68行目） | ○ |
| C-12 | callback-urlsデータ属性を渡す | E-03（69行目） | ○ |
| C-13 | oauth_application存在時のみデータを返す | E-03（62行目） | ○ |
| C-14 | WebIde::DefaultOauthApplication.oauth_applicationで確認 | E-02（34行目の参照のみ）、クラス未確認 | △ |

## 4) 不足情報（Unknown / Missing）

- **WebIde::DefaultOauthApplicationの詳細未確認**
  - `app/models/web_ide/default_oauth_application.rb`の内容を直接確認していない
  - OAuth アプリケーションの自動作成、コールバックURL管理の詳細が未確認

## 5) リスクフラグ（レビュー観点）

- **1: 中リスク** - セキュリティに関連するOAuth認証フローのため、トークン交換処理を確認すべき

## 6) レビュアーチェックリスト（最小）

- [ ] WebIde::DefaultOauthApplicationクラスの実装確認
- [ ] フロントエンドでのトークン交換処理の確認
- [ ] 親ウィンドウへのトークン転送方法の確認
- [ ] セキュリティ：state値によるCSRF対策の確認
